<?php

return CMap::mergeArray(
	require(dirname(__FILE__).'/db.php'),
	array(
		'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
		'name'=>'Kreatywnie w przedsiębiorczość',

		'sourceLanguage'=>'en',
		'language'=>'pl',

		'preload'=>array('log'),

		'import'=>array(
			'application.models.*',
			'application.components.*',
		),

		'modules'=>array(
			'administration',
			'teacher',
			'student',
		),

		'components'=>array(
			'cache'=>array(
				//'class'=>'CDbCache',
				'class'=>'CFileCache',
			),

			'clientScript'=>array(
				'class' => 'ext.yii-EClientScript.EClientScript',
				'combineScriptFiles' => false,
				'combineCssFiles' => true,
				'optimizeScriptFiles' => true,
				'optimizeCssFiles' => true,
				'optimizeInlineScript' => true,
				'optimizeInlineCss' => true,
				'packages'=>array(
					'jquery'=>array(
						'baseUrl'=>'js/lib',
						'js'=>array('jquery.min.js?1'),
					),
				),
			),

			'parameters'=>array(
				'class'=>'Parameters',
			),

			'session'=>array(
				'timeout'=>172800, //2 days
			),

			'user'=>array(
				'class'=>'CreativeUser',
				'allowAutoLogin'=>true,
				'authTimeout'=>172800, //2 days
				'autoUpdateFlash' => false
			),

			'urlManager'=>array(
				'urlFormat'=>'path',
				'showScriptName'=>false,
				'rules'=>array(
					''=>'site/index',

					'gii'=>'gii',
					'gii/<controller:\w+>'=>'gii/<controller>',
					'gii/<controller:\w+>/<action:\w+>'=>'gii/<controller>/<action>',

					'<controller:\w+>/<id:\d+>'=>'<controller>/view',
					'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
					'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
				),
			),

			'errorHandler'=>array(
				'errorAction'=>'site/error',
			),

			'log'=>array(
				'class'=>'CLogRouter',
				'routes'=>array(
					array(
						'class'=>'CFileLogRoute',
						'levels'=>'info, error, warning',
					)
					/*,
					array(
						'class'=>'CWebLogRoute',
						'levels'=>'trace',
						'categories'=>'vardump',
						'showInFireBug'=>true
					)
					*/
				),
			),
		),

		'params'=>array(
		),
	)
);
